__author__ = 'Fire Lizard'

from math import sqrt, fabs

class approximator2(object):

    def get_parameter(self, data, operation):
        result = 0
        n = len(data)
        for t in data:
            if not t[0] is None:
                if operation == "AV_X1":
                    result += t[0]
                if operation == "AV_X2":
                    result += t[1]
                if operation == "AV_Y":
                    result += t[2]
                if operation == "SUM_X1X2":
                    sx1 = self.get_parameter(data, "AV_X1")
                    sx2 = self.get_parameter(data, "AV_X2")
                    v1 = t[0] - sx1
                    v2 = t[1] - sx2
                    result += v1*v2
                if operation == "SUM_X1Y":
                    sx1 = self.get_parameter(data, "AV_X1")
                    sy = self.get_parameter(data, "AV_Y")
                    v1 = t[0] - sx1
                    v2 = t[2] - sy
                    result += v1*v2
                if operation == "SUM_X2Y":
                    sx2 = self.get_parameter(data, "AV_X2")
                    sy = self.get_parameter(data, "AV_Y")
                    v1 = t[1] - sx2
                    v2 = t[2] - sy
                    result += v1*v2
                if operation == "SUM_X12":
                    sx1 = self.get_parameter(data, "AV_X1")
                    result += (t[0] - sx1) ** 2
                if operation == "SUM_X22":
                    sx2 = self.get_parameter(data, "AV_X2")
                    result += (t[1] - sx2) ** 2
                if operation == "SIGMA_X":
                    b = self.get_b(data)
                    b2 = self.get_b2(data)
                    if b is None or b2 is None:
                        return None
                    sx1 = self.get_parameter(data, "AV_X1")
                    sx2 = self.get_parameter(data, "AV_X2")
                    v1 = (b/b2)*(t[0] - sx1)
                    v2 = (b2/b)*(t[1] - sx2)
                    s = v1 + v2
                    result += s ** 2
                if operation == "SIGMA_Y":
                    sy = self.get_parameter(data, "AV_Y")
                    result += (t[2] - sy) ** 2
                if operation == "SIGMA_XY":
                    b = self.get_b(data)
                    b2 = self.get_b2(data)
                    sx1 = self.get_parameter(data, "AV_X1")
                    sx2 = self.get_parameter(data, "AV_X2")
                    sy = self.get_parameter(data, "AV_Y")
                    v1 = (b/b2)*(t[0] - sx1)
                    v2 = (b2/b)*(t[1] - sx2)
                    s = v1 + v2
                    result += s*(t[2] - sy)
        if operation == "SIGMA_X" or operation == "SIGMA_Y" or operation == "SIGMA_XY":
            result /= n
            result = sqrt(fabs(result))
        return result

    def get_a(self, data):
        sx1 = self.get_parameter(data, "AV_X1")
        sx2 = self.get_parameter(data, "AV_X2")
        sy = self.get_parameter(data, "AV_Y")
        b = self.get_b(data)
        b2 = self.get_b2(data)
        result = sy - b2*sx1 - b*sx2
        return result

    def get_b(self, data):
        sx1x2 = self.get_parameter(data, "SUM_X1X2")
        sx1y = self.get_parameter(data, "SUM_X1Y")
        sx2y = self.get_parameter(data, "SUM_X2Y")
        sx12 = self.get_parameter(data, "SUM_X12")
        sx22 = self.get_parameter(data, "SUM_X22")
        result = sx12*sx2y - sx1x2*sx1y
        if (sx12*sx22 - (sx1x2 ** 2)) == 0:
            return None
        result /= (sx12*sx22 - (sx1x2 ** 2))
        return result

    def get_b2(self, data):
        sx1x2 = self.get_parameter(data, "SUM_X1X2")
        sx1y = self.get_parameter(data, "SUM_X1Y")
        sx2y = self.get_parameter(data, "SUM_X2Y")
        sx12 = self.get_parameter(data, "SUM_X12")
        sx22 = self.get_parameter(data, "SUM_X22")
        result = sx1y*sx22 - sx2y*sx1x2
        if (sx12*sx22 - (sx1x2 ** 2)) == 0:
            return None
        result /= (sx12*sx22 - (sx1x2 ** 2))
        return result

    def deviation(self, val1, val2):
        return 100 * fabs((val2 - val1) / val1)
    
    def delta(self, data1, data2):
        result = 0
        n = len(data1)
        for index in range(0, n):
            if data1[index][1] != 0:
                result += self.deviation(data1[index][1], data2[index][1])
        result /= n
        return result

    def sigma(self, data):
        n = len(data)
        a = self.get_a(data)
        b = self.get_b(data)
        b2 = self.get_b2(data)
        result = sum([(t[2] - a - b*t[0] - b2*t[1]) ** 2 if not t[0] is None else 0 for t in data])
        result /= n
        result = sqrt(fabs(result))
        return result

    def correlation(self, data):
        result = self.get_parameter(data, "SIGMA_XY") ** 2
        sx = self.get_parameter(data, "SIGMA_X")
        if sx != 0:
            result /= sx
        sy = self.get_parameter(data, "SIGMA_Y")
        if sy != 0:
            result /= sy
        if sx == 0 or sy == 0:
            result = None
        return result
