__author__ = 'Fire Lizard'

import sys
from xml.etree import ElementTree
from xml.dom import minidom
from xml.etree.ElementTree import Element, SubElement, Comment
if sys.platform == "win32":
    from easy_excel import easy_excel

class DataFormat(object):

    def format_xml(self, elem):
        rough_string = ElementTree.tostring(elem, 'utf-8')
        reparsed = minidom.parseString(rough_string)
        return reparsed.toprettyxml(indent="  ")

    def data2csv(self, data):
        lines = []
        for (x, y) in data:
            lines.append(str(x) + "," + str(y) + "\n")
        return lines

    def csv2data(self, csv):
        data = []
        for line in csv:
            parts = line.split(",")
            if len(parts) == 2:
                data.append((parts[0],parts[1].replace("\n", "")))
        return data

    def data2xml(self, data):
        top = Element("Data")
        comment = Comment('Generated by Approximator 1.7')
        top.append(comment)

        for (x, y) in data:
            point = SubElement(top, 'Point')
            elx = SubElement(point, 'X')
            elx.text = str(x)
            ely = SubElement(point, 'Y')
            ely.text = str(y)

        return self.format_xml(top)

    def xml2data(self, xml):
        tags = [(node.tag, node.text) for node in xml.iter()]
        data = []
        n = len(tags)
        for index in range(1, n, 3):
            x = tags[index + 1][1]
            y = tags[index + 2][1]
            data.append((x, y))
        return data

    def data2xlsx(self, data, filename):
        excel = easy_excel()
        n = len(data)
        for index in range(0, n):
            excel.setCell(1, index + 1, 1, data[index][0])
            excel.setCell(1, index + 1, 2, data[index][1])
        excel.save(filename)
        excel.close()

    def xlsx2data(self, xlsx):
        excel = easy_excel(xlsx)
        data = []
        index = 1
        while True:
            x = excel.getCell(1, index, 1)
            y = excel.getCell(1, index, 2)
            if not x is None and not y is None:
                data.append((str(x), str(y)))
            else:
                break
            index += 1
        excel.close()
        return data
