__author__ = 'Fire Lizard'

import sys

if sys.platform == "win32":

    import win32com.client
    import types

    class easy_excel:

        def __init__(self, filename=None):
            self.xlApp = win32com.client.Dispatch('Excel.Application')
            if filename:
                self.filename = filename
                self.xlBook = self.xlApp.Workbooks.Open(filename)
            else:
                self.xlBook = self.xlApp.Workbooks.Add()
                self.filename = ''

        def save(self, newfilename=None):
            if newfilename:
                self.filename = newfilename
                self.xlBook.SaveAs(newfilename)
            else:
                self.xlBook.Save()

        def close(self):
            self.xlBook.Close(SaveChanges=0)
            del self.xlApp

        def getCell(self, sheet, row, col):
            sht = self.xlBook.Worksheets(sheet)
            return sht.Cells(row, col).Value

        def setCell(self, sheet, row, col, value):
            sht = self.xlBook.Worksheets(sheet)
            sht.Cells(row, col).Value = value

        def getRange(self, sheet, row1, col1, row2, col2):
            sht = self.xlBook.Worksheets(sheet)
            return sht.Range(sht.Cells(row1, col1), sht.Cells(row2, col2)).Value

        def setRange(self, sheet, leftCol, topRow, data):
            bottomRow = topRow + len(data) - 1
            rightCol = leftCol + len(data[0]) - 1
            sht = self.xlBook.Worksheets(sheet)
            sht.Range(sht.Cells(topRow, leftCol), sht.Cells(bottomRow, rightCol)).Value = data

        def getContiguousRange(self, sheet, row, col):
            sht = self.xlBook.Worksheets(sheet)
            bottom = row
            while sht.Cells(bottom + 1, col).Value not in [None, '']:
                bottom += 1
            right = col
            while sht.Cells(row, right + 1).Value not in [None, '']:
                right += 1
            return sht.Range(sht.Cells(row, col), sht.Cells(bottom, right)).Value

        def fixStringsAndDates(self, aMatrix):
            newmatrix = []
            for row in aMatrix:
                newrow = []
                for cell in row:
                    if type(cell) is types.UnicodeType:
                        newrow.append(str(cell))
                    #elif type(cell) is types.TimeType:
                        #newrow.append(int(cell))
                    else:
                        newrow.append(cell)
                newmatrix.append(tuple(newrow))
            return newmatrix