__author__ = 'Fire Lizard'

import unittest
import functions
from util_data import calculate_ab, calculate_coefficients

class FunctionsTest(unittest.TestCase):

    def create_data(self, func):
        a = 2
        b = 2
        x = range(1, 50, 1)
        y = [func(a, b, float(val)) for val in x]
        n = len(x)
        data = []
        for i in range (0, n):
            data.append((float(x[i]), y[i]))
        return data

    def check_data(self, data, func):
        dst_data = []
        calculate_ab(data, dst_data, None, None, func)
        _, _, r = calculate_coefficients(data, dst_data, None, None, func)
        return r

    def test_func1(self):
        data = self.create_data(functions.func1)
        r = self.check_data(data, 1)
        self.assertAlmostEqual(r, 1)

    def test_func2(self):
        data = self.create_data(functions.func2)
        r = self.check_data(data, 2)
        self.assertAlmostEqual(r, 1)

    def test_func3(self):
        data = self.create_data(functions.func3)
        r = self.check_data(data, 3)
        self.assertAlmostEqual(r, 1)

    def test_func4(self):
        data = self.create_data(functions.func4)
        r = self.check_data(data, 4)
        self.assertAlmostEqual(r, 1)

    def test_func5(self):
        data = self.create_data(functions.func5)
        r = self.check_data(data, 5)
        self.assertAlmostEqual(r, 1)

    def test_func6(self):
        data = self.create_data(functions.func6)
        r = self.check_data(data, 6)
        self.assertAlmostEqual(r, 1)

    def test_func7(self):
        data = self.create_data(functions.func7)
        r = self.check_data(data, 7)
        self.assertAlmostEqual(r, 1)

    def test_func8(self):
        data = self.create_data(functions.func8)
        r = self.check_data(data, 8)
        self.assertAlmostEqual(r, 1)

    def test_func9(self):
        data = self.create_data(functions.func9)
        r = self.check_data(data, 9)
        self.assertAlmostEqual(r, 1)

    def test_func10(self):
        data = self.create_data(functions.func10)
        r = self.check_data(data, 10)
        self.assertAlmostEqual(r, 1)

    def test_func11(self):
        data = self.create_data(functions.func11)
        r = self.check_data(data, 11)
        self.assertAlmostEqual(r, 1)

    def test_func12(self):
        data = self.create_data(functions.func12)
        r = self.check_data(data, 12)
        self.assertAlmostEqual(r, 1)

    def test_func13(self):
        data = self.create_data(functions.func13)
        r = self.check_data(data, 13)
        self.assertAlmostEqual(r, 1)

    def test_func14(self):
        data = self.create_data(functions.func14)
        r = self.check_data(data, 14)
        self.assertAlmostEqual(r, 1)

    def test_func15(self):
        data = self.create_data(functions.func15)
        r = self.check_data(data, 15)
        self.assertAlmostEqual(r, 1)

    def test_func16(self):
        data = self.create_data(functions.func16)
        r = self.check_data(data, 16)
        self.assertAlmostEqual(r, 1)

    def test_func17(self):
        data = self.create_data(functions.func17)
        r = self.check_data(data, 17)
        self.assertAlmostEqual(r, 1)

if __name__ == '__main__':
    unittest.main()
