__author__ = 'Fire Lizard'

import sys

if sys.platform == 'win32' or sys.platform.startswith('linux'):
    from cx_Freeze import setup, Executable
else:
    from setuptools import setup

mainscript, ico, icns = "aproxim.py", "sum.ico", "sum.icns"

files = ["images/Diagram.png", "images/document.png", "images/Exit.png", "images/floppydisc.png",
         "images/folder.png", "images/Info.png", "images/settings.png"]
scripts = ["app_settings_dialog", "app_window", "approximator", "approximator2", "data_format",
           "easy_excel", "functions", "main_window", "settings_dialog",
           "util_data", "util_parameters"]

description = "Approximator is program for experimental data approximation and interpolation (20 dependencies for select)"

common_options = dict(name = "Approximator", version = "1.7", description = description)

if sys.platform == 'darwin':
    setup(
        setup_requires = ['py2app'],
        app = [mainscript],
        options = dict(py2app = dict(includes = scripts,
                                     resources = [('images', files), ('', [ico])],
                                     iconfile = icns)),
        **common_options)
elif sys.platform == 'win32':
    setup(
        options = dict(build_exe = dict(compressed = True, excludes = ["Tkinter"], path = sys.path,
                                        includes = scripts,
                                        include_files = files + [ico])),
        executables = [Executable(mainscript, base = "Win32GUI", icon = ico)],
        **common_options)
elif sys.platform.startswith('linux'):
    setup(
        options = dict(build_exe = dict(compressed = True, excludes = ["Tkinter"], path = sys.path,
                                        includes = scripts,
                                        include_files = files + [ico])),
#                                        include_files = files + [ico] + [(matplotlib.get_data_path(), "mpl-data")])),
        executables = [Executable(mainscript, base = None, icon = ico)],
        **common_options)
else:
    setup(
        data_files = [('', [ico] + [mainscript] + [script + ".py" for script in scripts]), ('images', files)],
        **common_options)
