__author__ = 'Fire Lizard'

from util_parameters import linear_parameters, calculate_parameters
from approximator import approximator
from approximator2 import approximator2
import functions

def linear_data(src_data, dst_data, n0, f):
    row = 0
    for t in src_data:
        row += 1
        x = t[0]
        y = t[1]
        try:
            x1, y1 =  linear_parameters(x, y, f, n0)
            val = (x1, y1, 0) if f != 20 else (x1, x, y1)
            dst_data.append(val)
        except ArithmeticError:
            dst_data.append((None, None, None))

def calculate_coefficients(src_data, dst_data, mbx, n0, f):
    data = []
    sign = 1 if n0 >= 0 else -1
    instance = approximator()
    if f == 19:
        linear_data(src_data, data, n0, f)
        delta = instance.delta(src_data, dst_data)
        sigma = instance.polynom_sigma(data, mbx, n0 + sign)
        r = instance.correlation_ratio(data, dst_data)
    else:
        linear_data(src_data, data, n0, f)
        delta = instance.delta(src_data, dst_data)
        sigma = instance.sigma(data)
        r = instance.correlation(data)
    return delta, sigma, r

def calculate_data(a1, b1, b2, src_data, dst_data, f, mbx, n0):
    deps = [functions.func1, functions.func2, functions.func3, functions.func4, 
            functions.func5, functions.func6, functions.func7, functions.func8, 
            functions.func9, functions.func10, functions.func11, functions.func12, 
            functions.func13, functions.func14, functions.func15, functions.func16, 
            functions.func17]
    for t in src_data:
        try:
            y1 = 0
            x1 = t[0]
            if f < 1:
                y1 = deps[0](a1, b1, x1)
            else:
                if f < 18:
                    y1 = deps[f - 1](a1, b1, x1)
                else:
                    if f == 18:
                        y1 = functions.func18(a1, b1, x1, n0)
                    elif f == 19:
                        y1 = functions.func19(mbx, x1, n0)
                    elif f == 20:
                        y1 = functions.func20(a1, b1, b2, x1)
            dst_data.append((x1, y1))
        except ZeroDivisionError:
            dst_data.append((None, None))
        except OverflowError:
            dst_data.append((None, None))
        except ValueError:
            dst_data.append((None, None))

def calculate_ab(src_data, dst_data, n0, mbx, f):
    b2 = 0
    data1 = []
    sign = 1 if n0 >= 0 else -1
    del dst_data[:]
    linear_data(src_data, data1, n0, f)
    a = 0
    b = 0
    instance = approximator()
    instance2 = approximator2()
    if f == 19:
        if not instance.get_polynom(data1, mbx, n0 + sign):
            return None, None, None
    else:
        if f <= 18:
            a = instance.get_a(data1)
            b = instance.get_b(data1)
        elif f == 20:
            a = instance2.get_a(data1)
            b = instance2.get_b(data1)
            b2 = instance2.get_b2(data1)
    if a is None or b is None or (f == 20 and b2 is None):
        return None, None, None
    a1, b1 = calculate_parameters(a, b, f)
    calculate_data(a1, b1, b2, src_data, dst_data, f, mbx, n0)
    return a1, b1, b2
