﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms.DataVisualization.Charting;

namespace aproxim
{
    public static class Approximator2
    {
        public static double GetParameter(List<DataPoint> data, string operation)
        {
            double result = 0;
            int n = data.Count;
            foreach (DataPoint t in data)
            {
                if (operation == "AV_X1")
                {
                    result += t.XValue;
                }
                if (operation == "AV_X2")
                {
                    result += t.YValues[0];
                }
                if (operation == "AV_Y")
                {
                    result += t.YValues[1];
                }
                if (operation == "SUM_X1X2")
                {
                    double sx1 = GetParameter(data, "AV_X1");
                    double sx2 = GetParameter(data, "AV_X2");
                    double v1 = t.XValue - sx1;
                    double v2 = t.YValues[0] - sx2;
                    result += v1*v2;
                }
                if (operation == "SUM_X1Y")
                {
                    double sx1 = GetParameter(data, "AV_X1");
                    double sy = GetParameter(data, "AV_Y");
                    double v1 = t.XValue - sx1;
                    double v2 = t.YValues[1] - sy;
                    result += v1*v2;
                }
                if (operation == "SUM_X2Y")
                {
                    double sx2 = GetParameter(data, "AV_X2");
                    double sy = GetParameter(data, "AV_Y");
                    double v1 = t.YValues[0] - sx2;
                    double v2 = t.YValues[1] - sy;
                    result += v1*v2;
                }
                if (operation == "SUM_X12")
                {
                    double sx1 = GetParameter(data, "AV_X1");
                    result += Math.Pow(t.XValue - sx1, 2);
                }
                if (operation == "SUM_X22")
                {
                    double sx2 = GetParameter(data, "AV_X2");
                    result += Math.Pow(t.YValues[0] - sx2, 2);
                }
                if (operation == "SIGMA_X")
                {
                    double b = GetB(data);
                    double b2 = GetB2(data);
                    double sx1 = GetParameter(data, "AV_X1");
                    double sx2 = GetParameter(data, "AV_X2");
                    double v1 = (b/b2)*(t.XValue - sx1);
                    double v2 = (b2/b)*(t.YValues[0] - sx2);
                    double s = v1 + v2;
                    result += Math.Pow(s, 2);
                }
                if (operation == "SIGMA_Y")
                {
                    double sy = GetParameter(data, "AV_Y");
                    result += Math.Pow(t.YValues[1] - sy, 2);
                }
                if (operation == "SIGMA_XY")
                {
                    double b = GetB(data);
                    double b2 = GetB2(data);
                    double sx1 = GetParameter(data, "AV_X1");
                    double sx2 = GetParameter(data, "AV_X2");
                    double sy = GetParameter(data, "AV_Y");
                    double v1 = (b/b2)*(t.XValue - sx1);
                    double v2 = (b2/b)*(t.YValues[0] - sx2);
                    double s = v1 + v2;
                    result += s*(t.YValues[1] - sy);
                }
            }
            if (operation == "SIGMA_X" || operation == "SIGMA_Y" || operation == "SIGMA_XY")
            {
                result /= n;
                result = Math.Sqrt(Math.Abs(result));
            }
            return result;
        }

        public static double GetA(List<DataPoint> data)
        {
            double sx1 = GetParameter(data, "AV_X1");
            double sx2 = GetParameter(data, "AV_X2");
            double sy = GetParameter(data, "AV_Y");
            double b = GetB(data);
            double b2 = GetB2(data);
            double result = sy - b2*sx1 - b*sx2;
            return result;
        }

        public static double GetB(List<DataPoint> data)
        {
            double sx1x2 = GetParameter(data, "SUM_X1X2");
            double sx1y = GetParameter(data, "SUM_X1Y");
            double sx2y = GetParameter(data, "SUM_X2Y");
            double sx12 = GetParameter(data, "SUM_X12");
            double sx22 = GetParameter(data, "SUM_X22");
            double result = sx12*sx2y - sx1x2*sx1y;
            result /= (sx12*sx22 - Math.Pow(sx1x2, 2));
            return result;
        }

        public static double GetB2(List<DataPoint> data)
        {
            double sx1x2 = GetParameter(data, "SUM_X1X2");
            double sx1y = GetParameter(data, "SUM_X1Y");
            double sx2y = GetParameter(data, "SUM_X2Y");
            double sx12 = GetParameter(data, "SUM_X12");
            double sx22 = GetParameter(data, "SUM_X22");
            double result = sx1y*sx22 - sx2y*sx1x2;
            result /= (sx12*sx22 - Math.Pow(sx1x2, 2));
            return result;
        }

        public static double Delta(List<DataPoint> data1, List<DataPoint> data2)
        {
            double result = 0;
            int n = data1.Count;
            for (int index = 0; index < n; index++)
            {
                result += (100 * Math.Abs(data1[index].YValues[1] - data2[index].YValues[1])) / data1[index].YValues[1];
            }
            result /= n;
            return result;
        }

        public static double Sigma(List<DataPoint> data)
        {
            int n = data.Count;
            double a = GetA(data);
            double b = GetB(data);
            double b2 = GetB2(data);
            double result = data.Sum(t => Math.Pow(t.YValues[1] - a - b*t.XValue - b2*t.YValues[0], 2));
            result /= n;
            result = Math.Sqrt(Math.Abs(result));
            return result;
        }

        public static double Correlation(List<DataPoint> data)
        {
            double result = Math.Pow(GetParameter(data, "SIGMA_XY"), 2);
            result /= GetParameter(data, "SIGMA_X");
            result /= GetParameter(data, "SIGMA_Y");
            return result;
        }
    }
}
