﻿using System;
using System.Collections.Generic;
using System.Windows.Forms.DataVisualization.Charting;

namespace aproxim
{
    public static class DataAnalysis
    {
        public static double Lagrange(List<DataPoint> data, double t, out double p)
        {
            List<double> x = new List<double>();
            List<double> f = new List<double>();
            foreach (DataPoint t1 in data)
            {
                x.Add(t1.XValue);
                f.Add(t1.YValues[0]);
            }
            int m;
            int i;
            int n = data.Count;
            List<double> df = new List<double>(n + 1);

            n = n - 1;
            for (i = 0; i <= n; i++)
            {
                df.Add(0);
            }
            for (m = 1; m <= n; m++)
            {
                for (i = 0; i <= n - m; i++)
                {
                    df[i] = ((t - x[i + m])*df[i] + f[i] + (x[i] - t)*df[i + 1] - f[i + 1])/(x[i] - x[i + m]);
                    f[i] = ((t - x[i + m])*f[i] + (x[i] - t)*f[i + 1])/(x[i] - x[i + m]);
                }
            }
            p = f[0];
            return df[0];
        }

        public static double Simpson(double a, double b, List<DataPoint> data)
        {
            const double epsilon = 0.0001;
            double x;

            double s2 = 1;
            double h = b - a;
            double s = LagrangeI(data, a) + LagrangeI(data, b);
            do
            {
                double s3 = s2;
                h /= 2;
                double s1 = 0;
                x = a + h;
                do
                {
                    s1 = s1 + 2*LagrangeI(data, x);
                    x = x + 2*h;
                } while (x < b);
                s = s + s1;
                s2 = (s + s1)*h/3;
                x = Math.Abs(s3 - s2)/15;
            } while (x > epsilon);
            return s2;
        }

        public static double LagrangeI(List<DataPoint> data, double t)
        {
            double res;
            Lagrange(data, t, out res);
            return res;
        }

        public static double LagrangeD(List<DataPoint> data, double t)
        {
            double p;
            return Lagrange(data, t, out p);
        }
    }
}
