﻿using System;
using System.Data;
using System.Diagnostics;

namespace aproxim
{
    public static class Excel
    {
//#if WINDOWS
        public static void OpenXls(DataTable table, string path)
        {
            const string appProgID = "Excel.Application";
            Type excelType = Type.GetTypeFromProgID(appProgID);
            if (excelType == null) return;
            dynamic excel = Activator.CreateInstance(excelType);
            excel.DisplayAlerts = false;
            dynamic workbooks = excel.Workbooks;
            dynamic workbook = workbooks.Open(new []{ path });
            try
            {
                dynamic worksheet = workbook.ActiveSheet;
                GetRowValues(table, worksheet);
            }
            finally
            {
                workbook.Close(new[] { false });
                Process[] procs = Process.GetProcessesByName("EXCEL");
                foreach (Process proc in procs)
                {
                    int baseAdd = proc.MainModule.BaseAddress.ToInt32();
                    if (baseAdd == excel.Hinstance)
                    {
                        proc.Kill();
                    }
                }
            }
        }
        
        public static void SaveXls(DataTable table, string path)
        {
            const string appProgID = "Excel.Application";
            Type excelType = Type.GetTypeFromProgID(appProgID);
            if (excelType == null) return;
            dynamic excel = Activator.CreateInstance(excelType);
            excel.DisplayAlerts = false;
            dynamic workbooks = excel.Workbooks;
            dynamic workbook = workbooks.Add();
            try
            {
                dynamic worksheet = workbook.ActiveSheet;
                for (int index = 0; index < table.Columns.Count; index++)
                {
                    dynamic cell = worksheet.Cells.Item(1, index + 1);
                    cell.Value = table.Columns[index].ColumnName;
                }
                SetRowValues(worksheet, table);
                workbook.SaveAs(new[] { path });
            }
            finally
            {
                workbook.Close(new[] { false });
                Process[] procs = Process.GetProcessesByName("EXCEL");
                foreach (Process proc in procs)
                {
                    int baseAdd = proc.MainModule.BaseAddress.ToInt32();
                    if (baseAdd == excel.Hinstance)
                    {
                        proc.Kill();
                    }
                }
            }
        }

        private static void GetRowValues(DataTable table, dynamic worksheet)
        {
            int count = worksheet.Rows.Count;
            for (int index = 0; index < count; index++)
            {
                DataRow row = table.NewRow();
                dynamic x = worksheet.Cells.Item(index + 2, 1).Value2;
                dynamic y = worksheet.Cells.Item(index + 2, 2).Value2;
                if (x == null || y == null) break;
                row["X"] = x;
                row["Y"] = y;
                table.Rows.Add(row);
            }
        }

        private static void SetRowValues(DataTable table, dynamic worksheet)
        {
            for (int index = 0; index < table.Rows.Count; index++)
            {
                for (int idx = 0; idx < table.Rows[index].ItemArray.Length; idx++)
                {
                    dynamic cell = worksheet.Cells.Item(index + 2, idx + 1);
                    cell.Value = table.Rows[index].ItemArray[idx];
                }
            }
        }
//#endif
    }
}
