﻿using System;
using System.Collections.Generic;
using System.Windows.Forms.DataVisualization.Charting;
using System.Linq;

namespace aproxim
{
    public static class Util
    {
        public static void LinearParameters(double x, double y, out double x1, out double y1, int func, int n0)
        {
            switch (func)
            {
                case 0:
                    x1 = x;
                    y1 = y;
                    break;
                case 1:
                    x1 = x;
                    y1 = y;
                    break;
                case 2:
                    x1 = 1/x;
                    y1 = y;
                    break;
                case 3:
                    x1 = Math.Log(Math.Abs(x));
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 4:
                    x1 = x;
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 5:
                    x1 = x;
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 6:
                    x1 = x;
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 7:
                    x1 = x;
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 8:
                    x1 = Math.Log(Math.Abs(x))/2.3;
                    y1 = y;
                    break;
                case 9:
                    x1 = Math.Log(Math.Abs(x));
                    y1 = y;
                    break;
                case 10:
                    x1 = 1/x;
                    y1 = 1/y;
                    break;
                case 11:
                    x1 = 1/x;
                    y1 = 1/y;
                    break;
                case 12:
                    x1 = x;
                    y1 = 1/y;
                    break;
                case 13:
                    x1 = x;
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 14:
                    x1 = Math.Exp(-x);
                    y1 = 1/y;
                    break;
                case 15:
                    x1 = x;
                    y1 = 1/y;
                    break;
                case 16:
                    x1 = 1/x;
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 17:
                    x1 = 1/x;
                    y1 = Math.Log(Math.Abs(y));
                    break;
                case 18:
                    x1 = Math.Pow(x, n0);
                    y1 = y;
                    break;
                case 19:
                    x1 = x;
                    y1 = y;
                    break;
                case 20:
                    x1 = Math.Log(Math.Abs(x));
                    y1 = Math.Log(Math.Abs(y));
                    break;
                default:
                    x1 = x;
                    y1 = y;
                    break;
            }
        }

        public static void CalculateParameters(double a, double b, out double a1, out double b1, int func)
        {
            switch (func)
            {
                case 0:
                    a1 = a;
                    b1 = b;
                    break;
                case 1:
                    a1 = a;
                    b1 = b;
                    break;
                case 2:
                    a1 = a;
                    b1 = b;
                    break;
                case 3:
                    a1 = a;
                    b1 = Math.Exp(b);
                    break;
                case 4:
                    a1 = a/Math.Log(10);
                    b1 = b/Math.Log(10);
                    break;
                case 5:
                    a1 = a;
                    b1 = b;
                    break;
                case 6:
                    a1 = a;
                    b1 = Math.Exp(b);
                    break;
                case 7:
                    a1 = Math.Exp(a);
                    b1 = Math.Exp(b);
                    break;
                case 8:
                    a1 = a;
                    b1 = b;
                    break;
                case 9:
                    a1 = a;
                    b1 = b;
                    break;
                case 10:
                    a1 = a;
                    b1 = b;
                    break;
                case 11:
                    a1 = a/b;
                    b1 = 1/b;
                    break;
                case 12:
                    a1 = a;
                    b1 = b;
                    break;
                case 13:
                    a1 = a/Math.Log(10);
                    b1 = Math.Exp(b);
                    break;
                case 14:
                    a1 = a;
                    b1 = b;
                    break;
                case 15:
                    a1 = b/a;
                    b1 = 1/a;
                    break;
                case 16:
                    a1 = a;
                    b1 = Math.Exp(b);
                    break;
                case 17:
                    a1 = a/Math.Log(10);
                    b1 = Math.Exp(b);
                    break;
                case 18:
                    a1 = a;
                    b1 = b;
                    break;
                case 20:
                    a1 = b;
                    b1 = Math.Exp(a);
                    break;
                default:
                    a1 = a;
                    b1 = b;
                    break;
            }
        }

        public static int LinearData(IEnumerable<DataPoint> src_data, List<DataPoint> linear_data, int n0, int f)
        {
            int row = 0;
            foreach (DataPoint t in src_data)
            {
                row++;
                double x = t.XValue;
                double y = t.YValues[0];
                double x1, y1;
                try
                {
                    LinearParameters(x, y, out x1, out y1, f, n0);
                }
                catch (Exception)
                {
                    return row;
                }
                linear_data.Add(f != 20 ? new DataPoint(x1, y1) : new DataPoint(x1, new[]{x, y1}));
            }
            return 0;
        }

        public static int CalculateData(List<DataPoint> src_data, List<DataPoint> dst_data, out double a1, out double b1,
                                        out double b2, int n0, List<double> mbx, ref int f)
        {
            List<DataPoint> linear_data = new List<DataPoint>();
            int sign = n0 >= 0 ? 1 : -1;
            dst_data.Clear();
            b2 = 0;
            int res = LinearData(src_data, linear_data, n0, f);
            if (res != 0)
            {
                a1 = 0;
                b1 = 0;
                b2 = 0;
                return res;
            }
            double a = 0;
            double b = 0;
            if (f == 19)
            {
                if (!Approximator.GetPolynom(linear_data, mbx, n0 + sign))
                {
                    f = 1;
                    a1 = 0;
                    b1 = 0;
                    b2 = 0;
                    return -1;
                }
            }
            else
            {
                if (f <= 18)
                {
                    a = Approximator.GetA(linear_data);
                    b = Approximator.GetB(linear_data);
                }
                else if (f == 20)
                {
                    a = Approximator2.GetA(linear_data);
                    b = Approximator2.GetB(linear_data);
                    b2 = Approximator2.GetB2(linear_data);
                }
            }
            CalculateParameters(a, b, out a1, out b1, f);
            List<Func<double, double, double, double>> deps = new List<Func<double, double, double, double>>
                                                                  {
                                                                      Functions.Func1,
                                                                      Functions.Func2,
                                                                      Functions.Func3,
                                                                      Functions.Func4,
                                                                      Functions.Func5,
                                                                      Functions.Func6,
                                                                      Functions.Func7,
                                                                      Functions.Func8,
                                                                      Functions.Func9,
                                                                      Functions.Func10,
                                                                      Functions.Func11,
                                                                      Functions.Func12,
                                                                      Functions.Func13,
                                                                      Functions.Func14,
                                                                      Functions.Func15,
                                                                      Functions.Func16,
                                                                      Functions.Func17
                                                                  };
            foreach (DataPoint t in src_data)
            {
                double y1 = 0;
                double x1 = t.XValue;
                if (f <= 1)
                {
                    y1 = deps[0](a1, b1, x1);
                }
                else
                {
                    if (f < 18)
                    {
                        y1 = deps[f - 1](a1, b1, x1);
                    }
                    else
                    {
                        if (f == 18)
                        {
                            y1 = Functions.Func18(a1, b1, x1, n0);
                        }
                        else if (f == 19)
                        {
                            y1 = Functions.Func19(mbx, x1, n0);
                        }
                        else if (f == 20)
                        {
                            y1 = Functions.Func20(a1, b1, b2, x1);
                        }
                    }
                }
                dst_data.Add(new DataPoint(x1, y1));
            }
            return 0;
        }

        public static void CalculateCoefficients(List<DataPoint> src_data, List<DataPoint> dst_data, List<double> mbx, int n0,
                                                 out double delta, out double sigma, out double r, int f)
        {
            List<DataPoint> linear_data = new List<DataPoint>();
            int sign = n0 >= 0 ? 1 : -1;
            if (f == 19)
            {
                LinearData(src_data, linear_data, n0, f);
                delta = Approximator.Delta(src_data, dst_data);
                sigma = Approximator.PolynomSigma(linear_data, mbx, n0 + sign);
                r = Approximator.CorrelationRatio(linear_data, dst_data);
            }
            else
            {
                LinearData(src_data, linear_data, n0, f);
                delta = Approximator.Delta(src_data, dst_data);
                sigma = Approximator.Sigma(linear_data);
                r = Approximator.Correlation(linear_data);
            }
        }

        public static DataPoint CalculateMax(IList<DataPoint> data)
        {
            int f;
            DataPoint result = data[0];
            do
            {
                f = 0;
                foreach (DataPoint t in data)
                {
                    if (result.XValue < t.XValue)
                    {
                        result.XValue = t.XValue;
                        f = 1;
                    }
                    if (result.YValues[0] < t.YValues[0])
                    {
                        result.YValues[0] = t.YValues[0];
                        f = 1;
                    }
                }
            } while (f == 1);
            return result;
        }

        public static DataPoint CalculateMin(IList<DataPoint> data)
        {
            int f;
            DataPoint result = data[0];
            do
            {
                f = 0;
                foreach (DataPoint t in data)
                {
                    if (result.XValue > t.XValue)
                    {
                        result.XValue = t.XValue;
                        f = 1;
                    }
                    if (result.YValues[0] > t.YValues[0])
                    {
                        result.YValues[0] = t.YValues[0];
                        f = 1;
                    }
                }
            } while (f == 1);
            return result;
        }

        public static DataPoint GetLesserThan(List<DataPoint> data, double x)
        {
            DataPoint result = data[0];
            foreach (DataPoint t in data)
            {
                if (Math.Abs(result.XValue - x) > Math.Abs(t.XValue - x) && t.XValue < x)
                {
                    result = t;
                }
            }
            return result;
        }

        public static DataPoint GetGreaterThan(List<DataPoint> data, double x)
        {
            DataPoint result = data[0];
            foreach (DataPoint t in data)
            {
                if (Math.Abs(result.XValue - x) > Math.Abs(t.XValue - x) && t.XValue > x)
                {
                    result = t;
                }
            }
            return result;
        }

        public static Tuple<double, double, double> GetParameters(double v1, double v2)
        {
            double ar = (v1 + v2)/2;
            double geom = Math.Sqrt(v1*v2);
            double garm = 2*v1*v2/(v1 + v2);
            Tuple<double, double, double> result = new Tuple<double, double, double>(ar, geom, garm);
            return result;
        }

        public static double Interpolation(double x1, double x2, double y1, double y2, double xar)
        {
            return y1 + (((y2 - y1)/(x2 - x1))*(xar - x1));
        }

        public static double GetParameter(List<DataPoint> data, double xparam)
        {
            DataPoint p1 = GetLesserThan(data, xparam);
            DataPoint p2 = GetGreaterThan(data, xparam);
            return Interpolation(p1.XValue, p2.XValue, p1.YValues[0], p2.YValues[0], xparam);
        }

        public static int Epsilon(List<DataPoint> data)
        {
            const double e = 0.0001;
            double xminval = CalculateMin(data).XValue;
            double xmaxval = CalculateMax(data).XValue;
            double yminval = CalculateMin(data).YValues[0];
            double ymaxval = CalculateMax(data).YValues[0];
            Tuple<double, double, double> xtuple = GetParameters(xminval, xmaxval);
            Tuple<double, double, double> ytuple = GetParameters(yminval, ymaxval);
            double ar = GetParameter(data, xtuple.Item1);
            double geom = GetParameter(data, xtuple.Item2);
            double garm = GetParameter(data, xtuple.Item3);
            double[] arr = new[]
                               {
                                   Math.Abs(ar - ytuple.Item1), Math.Abs(ar - ytuple.Item2), Math.Abs(ar - ytuple.Item3),
                                   Math.Abs(geom - ytuple.Item1), Math.Abs(geom - ytuple.Item2),
                                   Math.Abs(garm - ytuple.Item1), Math.Abs(garm - ytuple.Item3)
                               };
            List<double> epsilons = new List<double>(arr);
            double minvalue = epsilons.Min();
            for (int index = 0; index < epsilons.Count; index++)
            {
                if (Math.Abs(minvalue - epsilons[index]) < e)
                {
                    return index + 1;
                }
            }
            return 0;
        }
    }
}
