__author__ = 'Fire Lizard'

from math import sqrt, fabs

class approximator(object):

    def get_parameter(self, data, operation):
        result = 0
        n = len(data)
        for t in data:
            if not t[0] is None:
                if operation == "AV_X":
                    result += t[0]/n
                if operation == "AV_Y":
                    result += t[1]/n
                if operation == "SUM_X":
                    result += t[0]
                if operation == "SUM_Y":
                    result += t[1]
                if operation == "SUM_XY":
                    result += t[0]*t[1]
                if operation == "SUM_X2":
                    result += t[0] ** 2
                if operation == "SIGMA_X":
                    result += (t[0] - self.get_parameter(data, "AV_X")) ** 2
                if operation == "SIGMA_Y":
                    result += (t[1] - self.get_parameter(data, "AV_Y")) ** 2
                if operation == "SIGMA_XY":
                    val1 = t[0] - self.get_parameter(data, "AV_X")
                    val2 = t[1] - self.get_parameter(data, "AV_Y")
                    result += val1*val2
        if operation == "SIGMA_X" or operation == "SIGMA_Y" or operation == "SIGMA_XY":
            result /= n
            result = sqrt(fabs(result))
        return result

    def get_a(self, data):
        n = len(data)
        sx = self.get_parameter(data, "SUM_X")
        sy = self.get_parameter(data, "SUM_Y")
        sxy = self.get_parameter(data, "SUM_XY")
        sx2 = self.get_parameter(data, "SUM_X2")
        result = sx*sy - n*sxy
        if ((sx ** 2) - n*sx2) == 0:
            return None
        result /= ((sx ** 2) - n*sx2)
        return result

    def get_b(self, data):
        n = len(data)
        sx = self.get_parameter(data, "SUM_X")
        sy = self.get_parameter(data, "SUM_Y")
        sxy = self.get_parameter(data, "SUM_XY")
        sx2 = self.get_parameter(data, "SUM_X2")
        result = sx*sxy - sy*sx2
        if ((sx ** 2) - n*sx2) == 0:
            return None
        result /= ((sx ** 2) - n*sx2)
        return result

    def deviation(self, val1, val2):
        return 100 * fabs((val2 - val1) / val1)
    
    def delta(self, data1, data2):
        result = 0
        n = len(data1)
        for index in range(0, n):
            if data1[index][1] != 0 and not data2[index][1] is None:
                result += self.deviation(data1[index][1], data2[index][1])
        result /= n
        return result

    def sigma(self, data):
        n = len(data)
        a = self.get_a(data)
        b = self.get_b(data)
        result = sum([(t[1] - b - a*t[0]) ** 2 if not t[0] is None else 0 for t in data])
        result /= n
        result = sqrt(fabs(result))
        return result

    def polynom_sigma(self, data, mbx, n0):
        result = 0
        n = len(data)
        for t in data:
            r = 0
            sign = 1 if n0 >= 0 else -1
            for idx in range(sign, n0, sign):
                r += mbx[int(fabs(idx))]*(t[0] ** idx)
            r += mbx[0]
            result += (t[1] - r) ** 2
        result /= n
        result = sqrt(fabs(result))
        return result

    def correlation(self, data):
        result = self.get_parameter(data, "SIGMA_XY") ** 2
        sx = self.get_parameter(data, "SIGMA_X")
        if sx != 0:
            result /= sx
        sy = self.get_parameter(data, "SIGMA_Y")
        if sy != 0:
            result /= sy
        if sx == 0 or sy == 0:
            result = None
        return result

    def correlation_ratio(self, linear_data, dst_data):
        n = len(dst_data)
        sry = self.get_parameter(dst_data, "AV_Y")
        sigma2 = sum([(t[1] - sry) ** 2 for t in dst_data])
        sigma2 /= n
        lambda2 = sum([(t[1] - sry) ** 2 for t in linear_data])
        lambda2 /= n
        result = sqrt(sigma2/lambda2)
        return result

    def zeidel(self, a, b, mbx, n):
        for _ in range(0, int(n)): mbx.append(0)
        e = 0.001
        iCount = 0
        while True:
            m = 0
            for i in range(0, int(n)):
                s1 = 0
                s2 = 0
                for j in range(0, i): s1 += a[i][j]*mbx[j]
                for j in range(i, int(n)): s2 += a[i][j]*mbx[j]
                v = mbx[i]
                try:
                    mbx[i] -= (1 / a[i][i]) * (s1 + s2 - b[i])
                except ZeroDivisionError:
                    return False
                diff = fabs(v - mbx[i])
                m = diff if diff > m else m
            iCount += 1
            if iCount > 100000: return False
            if m <= e: break
        return True

    def get_polynom(self, data, mbx, n):
        sy = []
        sx = []
        a = []
        for i in range(0, n):
            a.append([])
            for j in range(0, n):
                a[i].append(0)
        del mbx[:]
        sign = 1 if n >= 0 else -1
        for index in range(0, 2*n - sign, sign):
            sx.append(0)
            for t in data:
                sx[int(fabs(index))] += t[0] ** index
        for index in range(0, n, sign):
            sy.append(0)
            for t in data:
                sy[int(fabs(index))] += t[1]*(t[0] ** index)
        for i in range(0, int(fabs(n))):
            for j in range(0, int(fabs(n))):
                a[i][j] = sx[i + j]
        result = self.zeidel(a, sy, mbx, fabs(n))
        return result
